import React from "react";

export default function Layout({ sidebar, children }) {
  return (
    <div className="flex h-screen w-full bg-gray-950 text-gray-100 overflow-hidden font-sans">
      <aside className="w-80 shrink-0 border-r border-gray-800 bg-gray-900 flex flex-col">
        {sidebar}
      </aside>
      <main className="flex-1 flex flex-col min-w-0 bg-gray-950">
        {children}
      </main>
    </div>
  );
}
